/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CollisionAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Elastischer und unelastischer Sto\u00df", "Elastischer Sto\u00df", "Unelastischer Sto\u00df", "Zur\u00fcck", "Start", "Zeitlupe", "Wagen 1:", "Wagen 2:", "Masse:", "Geschwindigkeit:", "Geschwindigkeit", "Impuls", "Kinetische Energie", "Geschwindigkeiten vor dem Sto\u00df:", "Geschwindigkeiten nach dem Sto\u00df:", "Impulse vor dem Sto\u00df:", "Impulse nach dem Sto\u00df:", "Kinetische Energie vor dem Sto\u00df:", "Kinetische Energie nach dem Sto\u00df:", "Gesamtimpuls:", "Gesamte kinetische Energie:", ""}, {"en", "Elastic and Inelastic Collision", "Elastic collision", "Inelastic collision", "Reset", "Start", "Slow motion", "Wagon 1:", "Wagon 2:", "Mass:", "Velocity:", "Velocity", "Momentum", "Kinetic energy", "Velocities before the collision:", "Velocities after the collision:", "Momenta before the collision:", "Momenta after the collision:", "Kinetic energy before the collision:", "Kinetic energy after the collision:", "Total momentum:", "Total kinetic energy:", ""}};
    private int[] gaps = new int[]{5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 5, 0, 5};
    final int width = 660;
    final int height = 440;
    final int width0 = 400;
    final int yM = 220;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    ResetButton buReset;
    StartButton buStart;
    JTextField tfm1;
    JTextField tfv1;
    JTextField tfm2;
    JTextField tfv2;
    JCheckBox cbSlow;
    JRadioButton rbElastic;
    JRadioButton rbInelastic;
    JRadioButton rbV;
    JRadioButton rbP;
    JRadioButton rbE;
    final Color BLACK = Color.black;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color color1;
    Color color2;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    double t;
    boolean on;
    boolean slow;
    double m1;
    double m2;
    double v1Old;
    double v2Old;
    double v1New;
    double v2New;
    double p1Old;
    double p2Old;
    double p1New;
    double p2New;
    double e1Old;
    double e2Old;
    double e1New;
    double e2New;
    final double lWagon = 0.1;
    double height1;
    double height2;
    final double s = 1.0;
    final double factor = 400.0;
    boolean elastic;
    double[] positions;
    final double dSpring = 500.0;
    final double lSpring = 0.05;
    double omega;
    double a1Max;
    double x1Beg;
    double x2Beg;
    double x1End;
    double x2End;
    double tBeg;
    double tMid;
    double tEnd;
    double c1;
    double c2;
    double c3;
    final double dMax = 0.09;
    final double dMin = 0.0575;
    double c4;
    double c5;
    double c6;
    double c7;
    double d0;
    double[] p1x;
    double[] p1y;
    double[] p2x;
    double[] p2y;
    double[] p3x;
    double[] p3y;
    double cos;
    double sin;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(660, 440);
    }

    @Override
    protected void initAttributes() {
        this.positions = new double[2];
        this.p1x = new double[9];
        this.p1y = new double[9];
        this.p2x = new double[7];
        this.p2y = new double[7];
        this.p3x = new double[13];
        this.p3y = new double[13];
        this.t = 0.0;
        this.slow = false;
        this.on = false;
        this.m2 = 0.5;
        this.m1 = 0.5;
        this.v1Old = 0.2;
        this.v2Old = 0.0;
        this.height2 = 25.0;
        this.height1 = 25.0;
        this.elastic = true;
        this.calcElastic();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.color1 = this.getColor(Color.red, "color1");
        this.color2 = this.getColor(Color.blue, "color2");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.coauthor = this.getText(t[22], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 400, 440);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(400, 0, 260, 440);
        ButtonGroup bg = new ButtonGroup();
        this.rbElastic = new JRadioButton(this.text01, true);
        bg.add(this.rbElastic);
        this.pan.add(this.rbElastic, this.bgPanel, this.BLACK);
        this.rbInelastic = new JRadioButton(this.text02, false);
        bg.add(this.rbInelastic);
        this.pan.add(this.rbInelastic, this.bgPanel, this.BLACK);
        this.buReset = new ResetButton(this.text03);
        this.pan.add(this.buReset, this.colorButton1, this.BLACK);
        this.buStart = new StartButton(this.text04, "", "");
        this.pan.add(this.buStart, this.colorButton2, this.BLACK);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, this.BLACK);
        this.pan.add(this.text06, this.color1);
        this.tfm1 = this.pan.newInputField(this.text08, this.kilogram, this.bgPanel, this.color1, 2);
        this.tfm1.setText(this.toString(this.m1, 1));
        this.tfv1 = this.pan.newInputField(this.text09, this.meterPerSecond, this.bgPanel, this.color1, 2);
        this.tfv1.setText(this.toString(this.v1Old, 1));
        this.pan.add(this.text07, this.color2);
        this.tfm2 = this.pan.newInputField(this.text08, this.kilogram, this.bgPanel, this.color2, 2);
        this.tfm2.setText(this.toString(this.m2, 1));
        this.tfv2 = this.pan.newInputField(this.text09, this.meterPerSecond, this.bgPanel, this.color2, 2);
        this.tfv2.setText(this.toString(this.v2Old, 1));
        bg = new ButtonGroup();
        this.rbV = new JRadioButton(this.text10, true);
        bg.add(this.rbV);
        this.pan.add(this.rbV, this.bgPanel, this.BLACK);
        this.rbP = new JRadioButton(this.text11, false);
        bg.add(this.rbP);
        this.pan.add(this.rbP, this.bgPanel, this.BLACK);
        this.rbE = new JRadioButton(this.text12, false);
        bg.add(this.rbE);
        this.pan.add(this.rbE, this.bgPanel, this.BLACK);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.rbElastic.addActionListener(this);
        this.rbInelastic.addActionListener(this);
        this.buReset.addActionListener(this);
        this.buStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
        this.rbV.addActionListener(this);
        this.rbP.addActionListener(this);
        this.rbE.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                this.t += this.slow ? dt / 10.0 : dt;
            }
            t0 = t1;
        }
    }

    void setPoint1(int i, double x0, double x, int y) {
        this.p1x[i] = x0 + x;
        this.p1y[i] = 200 - y;
    }

    void setPoint2(int i, double x0, double x, int y) {
        this.p2x[i] = x0 + x * this.cos - (double)y * this.sin;
        this.p2y[i] = 197.0 - (double)y * this.cos - x * this.sin;
    }

    void setPoint3(int i, double x0, double x, int y) {
        this.p3x[i] = x0 + x;
        this.p3y[i] = 200 - y;
    }

    void setTime(double dt) {
        this.tBeg = -dt;
        double t10 = this.v1Old > 0.0 ? this.tBeg - (this.x1Beg + 0.05) / this.v1Old : (this.v1Old < 0.0 ? this.tBeg - (1.05 - this.x1Beg) / -this.v1Old : 0.0);
        double t20 = this.v2Old > 0.0 ? this.tBeg - (this.x2Beg + 0.05) / this.v2Old : (this.v2Old < 0.0 ? this.tBeg - (1.05 - this.x2Beg) / -this.v2Old : 0.0);
        this.tMid = -Math.min(t10, t20) + 0.5;
        this.tBeg = this.tMid - dt;
        this.tEnd = this.tMid + dt;
    }

    void calcPE() {
        this.p1Old = this.m1 * this.v1Old;
        this.p2Old = this.m2 * this.v2Old;
        this.p1New = this.m1 * this.v1New;
        this.p2New = this.m2 * this.v2New;
        this.e1Old = this.m1 / 2.0 * this.v1Old * this.v1Old;
        this.e2Old = this.m2 / 2.0 * this.v2Old * this.v2Old;
        this.e1New = this.m1 / 2.0 * this.v1New * this.v1New;
        this.e2New = this.m2 / 2.0 * this.v2New * this.v2New;
    }

    void calcElastic() {
        double mSum = this.m1 + this.m2;
        this.v1New = (this.m1 * this.v1Old + this.m2 * (2.0 * this.v2Old - this.v1Old)) / mSum;
        this.v2New = (this.m2 * this.v2Old + this.m1 * (2.0 * this.v1Old - this.v2Old)) / mSum;
        this.calcPE();
        this.omega = Math.sqrt(mSum * 500.0 / (this.m1 * this.m2));
        this.a1Max = (this.v1Old - this.v1New) * this.omega / 2.0;
        this.c1 = this.a1Max / this.omega;
        this.c2 = this.c1 / this.omega;
        this.c3 = this.c1 * Math.PI / (2.0 * this.omega);
        double distMin = 0.15000000000000002 - this.a1Max * this.m1 / 500.0;
        double dt = Math.PI / (2.0 * this.omega);
        double dx1 = this.a1Max * -0.5707963267948966 / (this.omega * this.omega) + this.v1Old * Math.PI / (2.0 * this.omega);
        this.x1Beg = 0.5 - distMin / 2.0 - dx1;
        this.x2Beg = this.x1Beg + 0.05 + 0.1;
        this.x1End = this.x1Beg + this.v1Old * 2.0 * dt - this.c1 * dt + this.c2 * Math.cos(this.omega * dt) - this.c3;
        this.x2End = this.x1End + 0.05 + 0.1;
        this.setTime(dt);
    }

    void calcInelastic() {
        this.v1New = this.v2New = (this.m1 * this.v1Old + this.m2 * this.v2Old) / (this.m1 + this.m2);
        this.calcPE();
        double dt = 0.032499999999999994 / (this.v1Old - this.v2Old);
        this.c4 = (this.v1New - this.v1Old) / (4.0 * dt);
        this.c5 = (this.v1Old + this.v1New) / 2.0;
        this.c6 = (this.v2New - this.v2Old) / (4.0 * dt);
        this.c7 = (this.v2Old + this.v2New) / 2.0;
        this.d0 = (this.c4 - this.c6) * dt * dt + (this.c7 - this.c5) * dt + 0.09;
        this.x1Beg = this.c4 * dt * dt - this.c5 * dt + (1.0 - this.d0 - 0.1) / 2.0;
        this.x1End = this.c4 * dt * dt + this.c5 * dt + (1.0 - this.d0 - 0.1) / 2.0;
        this.x2Beg = this.c6 * dt * dt - this.c7 * dt + (1.0 + this.d0 + 0.1) / 2.0;
        this.x2End = this.c6 * dt * dt + this.c7 * dt + (1.0 + this.d0 + 0.1) / 2.0;
        this.setTime(dt);
    }

    void calculateX() {
        if (this.t < this.tBeg) {
            double dt = this.t - this.tBeg;
            this.positions[0] = this.x1Beg + this.v1Old * dt;
            this.positions[1] = this.x2Beg + this.v2Old * dt;
        } else if (this.t < this.tEnd) {
            double dt = this.t - this.tMid;
            if (this.elastic) {
                double cos = Math.cos(this.omega * dt);
                this.positions[0] = this.x1Beg + this.v1Old * (this.t - this.tBeg) - this.c1 * dt + this.c2 * cos - this.c3;
                this.positions[1] = this.positions[0] + 0.1 + 0.05 - this.a1Max * cos * this.m1 / 500.0;
            } else {
                this.positions[0] = this.c4 * dt * dt + this.c5 * dt + (1.0 - this.d0 - 0.1) / 2.0;
                this.positions[1] = this.c6 * dt * dt + this.c7 * dt + (1.0 + this.d0 + 0.1) / 2.0;
            }
        } else {
            double dt = this.t - this.tEnd;
            this.positions[0] = this.x1End + this.v1New * dt;
            this.positions[1] = this.x2End + this.v2New * dt;
        }
    }

    void updateValues() {
        this.m1 = this.inputTF(this.tfm1, 0.1, 1.0, 1);
        this.v1Old = this.inputTF(this.tfv1, this.v2Old + 0.1, 0.5, 1);
        this.m2 = this.inputTF(this.tfm2, 0.1, 1.0, 1);
        this.v2Old = this.inputTF(this.tfv2, -0.5, this.v1Old - 0.1, 1);
        this.height1 = 15.0 + 20.0 * this.m1;
        this.height2 = 15.0 + 20.0 * this.m2;
    }

    void actionEnd() {
        if (this.elastic) {
            this.calcElastic();
        } else {
            this.calcInelastic();
        }
    }

    void enableTF(boolean flag) {
        this.tfm1.setEnabled(flag);
        this.tfv1.setEnabled(flag);
        this.tfm2.setEnabled(flag);
        this.tfv2.setEnabled(flag);
        this.rbElastic.setEnabled(flag);
        this.rbInelastic.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.elastic = this.rbElastic.isSelected();
        this.slow = this.cbSlow.isSelected();
        Object o = ae.getSource();
        if (o == this.buReset) {
            this.enableTF(true);
            this.on = false;
            this.t = 0.0;
        } else if (o == this.buStart) {
            this.enableTF(false);
            this.updateValues();
            this.on = true;
        } else if (o instanceof JTextField) {
            this.updateValues();
        }
        this.actionEnd();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, CollisionAP.this.bgCanvas);
            CollisionAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void wagon(Graphics2D g, Color c, double x, double h) {
            double x0 = x * 400.0;
            double d1 = 20.0;
            double d2 = d1 / 2.0;
            CanvasAP.rectangle(g, x0 - d1, 208.0 - h, 2.0 * d1, h, c, true);
            CanvasAP.circle(g, x0 - d2, 210.0, 5.0, Color.orange, true);
            CanvasAP.circle(g, x0 + d2, 210.0, 5.0, Color.orange, true);
        }

        void spring(Graphics2D g, double xL, double xR) {
            g.setColor(CollisionAP.this.BLACK);
            double xxL = xL * 400.0;
            double xxR = xR * 400.0;
            CanvasAP.line(g, xxL, 200.0, xxL + 2.0, 200.0);
            double x0 = xxL + 2.0;
            double y0 = 200.0;
            double k = Math.PI * 6 / (xxR - x0);
            while (x0 < xxR) {
                double x1 = x0 + 1.0;
                double y1 = 200.0 + 10.0 * Math.sin(k * (x1 - xxL));
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            CanvasAP.line(g, x0, y0, x0 + 1.0, 200.0);
        }

        void kupplung(Graphics2D g, double x1, double x2, double alpha) {
            double xL = (x1 + 0.05) * 400.0;
            CollisionAP.this.setPoint1(0, xL, 0.0, 2);
            CollisionAP.this.setPoint1(1, xL, 0.0, -3);
            CollisionAP.this.setPoint1(2, xL, 2.0, -3);
            CollisionAP.this.setPoint1(3, xL, 2.0, -6);
            CollisionAP.this.setPoint1(4, xL, 6.0, -6);
            CollisionAP.this.setPoint1(5, xL, 6.0, 5);
            CollisionAP.this.setPoint1(6, xL, 2.0, 5);
            CollisionAP.this.setPoint1(7, xL, 2.0, 2);
            CollisionAP.this.setPoint1(8, xL, 0.0, 2);
            CanvasAP.polygon(g, CollisionAP.this.p1x, CollisionAP.this.p1y, CollisionAP.this.BLACK, true);
            double xA = xL + 4.0;
            CollisionAP.this.cos = Math.cos(alpha);
            CollisionAP.this.sin = Math.sin(alpha);
            CollisionAP.this.setPoint2(0, xA, -2.0, 2);
            CollisionAP.this.setPoint2(1, xA, -2.0, -2);
            CollisionAP.this.setPoint2(2, xA, 8.0, -2);
            CollisionAP.this.setPoint2(3, xA, 8.0, -5);
            CollisionAP.this.setPoint2(4, xA, 12.0, -1);
            CollisionAP.this.setPoint2(5, xA, 12.0, 2);
            CollisionAP.this.setPoint2(6, xA, -2.0, 2);
            CanvasAP.polygon(g, CollisionAP.this.p2x, CollisionAP.this.p2y, CollisionAP.this.BLACK, true);
            double xR = (x2 - 0.05) * 400.0;
            CollisionAP.this.setPoint3(0, xR, 0.0, 2);
            CollisionAP.this.setPoint3(1, xR, -2.0, 2);
            CollisionAP.this.setPoint3(2, xR, -2.0, 5);
            CollisionAP.this.setPoint3(3, xR, -6.0, 5);
            CollisionAP.this.setPoint3(4, xR, -6.0, -2);
            CollisionAP.this.setPoint3(5, xR, -12.0, -2);
            CollisionAP.this.setPoint3(6, xR, -12.0, 1);
            CollisionAP.this.setPoint3(7, xR, -16.0, -3);
            CollisionAP.this.setPoint3(8, xR, -16.0, -6);
            CollisionAP.this.setPoint3(9, xR, -2.0, -6);
            CollisionAP.this.setPoint3(10, xR, -2.0, -3);
            CollisionAP.this.setPoint3(11, xR, 0.0, -3);
            CollisionAP.this.setPoint3(12, xR, 0.0, 2);
            CanvasAP.polygon(g, CollisionAP.this.p3x, CollisionAP.this.p3y, CollisionAP.this.BLACK, true);
        }

        void horizontalArrow(Graphics2D g, double x, double y, double length) {
            Color c = g.getColor();
            if (Math.abs(length) >= 1.0) {
                CanvasAP.arrow(g, 3.0, x, y, x + length, y);
            } else {
                CanvasAP.circle(g, x, y, 1.5, c);
            }
        }

        void write(Graphics2D g, String text, double z, String unit, int x, int y, int align) {
            String s = text + "  " + CollisionAP.this.toString2(z, 3, 1.0E-6) + " " + unit;
            this.alignText(g, s, this.fH, align + 1, x, y);
        }

        void drawArrows(Graphics2D g, int nr, double vOld, double vNew) {
            int f = 200;
            double vvOld = vOld * (double)f;
            double vvNew = vNew * (double)f;
            int x = nr == 1 ? 50 : 350;
            g.setColor(CollisionAP.this.BLACK);
            g.setColor(nr == 1 ? CollisionAP.this.color1 : CollisionAP.this.color2);
            double xx = x;
            if (nr == 1 && vvOld < 0.0) {
                xx = (double)x - vvOld;
            }
            if (nr == 2 && vvOld >= 0.0) {
                xx = (double)x - vvOld;
            }
            this.horizontalArrow(g, xx, 85.0, vvOld);
            xx = x;
            if (nr == 1 && vvNew < 0.0) {
                xx = (double)x - vvNew;
            }
            if (nr == 2 && vvNew >= 0.0) {
                xx = (double)x - vvNew;
            }
            this.horizontalArrow(g, xx, 345.0, vvNew);
            CanvasAP.setAntiAliasing(g, false);
            String mps = CollisionAP.this.meterPerSecond;
            String w = nr == 1 ? CollisionAP.this.text06 : CollisionAP.this.text07;
            this.write(g, w, vOld, mps, x, 115, nr == 1 ? -1 : 1);
            this.write(g, w, vNew, mps, x, 375, nr == 1 ? -1 : 1);
            CanvasAP.setAntiAliasing(g, true);
        }

        void velocity(Graphics2D g) {
            this.drawArrows(g, 1, CollisionAP.this.v1Old, CollisionAP.this.v1New);
            this.drawArrows(g, 2, CollisionAP.this.v2Old, CollisionAP.this.v2New);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(CollisionAP.this.BLACK);
            g.drawString(CollisionAP.this.text13, 50, 60);
            g.drawString(CollisionAP.this.text14, 50, 320);
        }

        void sumVectors(Graphics2D g, double p1, double p2, int y) {
            int f = 300;
            double y2 = p1 * p2 > 0.0 ? y : y + 5;
            double w1 = (double)f * p1;
            double w2 = (double)f * p2;
            double w = w1 + w2;
            double x = 200.0 - w / 2.0;
            g.setColor(CollisionAP.this.color1);
            this.horizontalArrow(g, x, y, w1);
            g.setColor(CollisionAP.this.color2);
            this.horizontalArrow(g, x + w1, y2, w2);
            g.setColor(CollisionAP.this.BLACK);
            this.horizontalArrow(g, x, y + 10, w);
        }

        void momentum(Graphics2D g) {
            double p = CollisionAP.this.p1Old + CollisionAP.this.p2Old;
            g.setColor(CollisionAP.this.BLACK);
            this.sumVectors(g, CollisionAP.this.p1Old, CollisionAP.this.p2Old, 65);
            this.sumVectors(g, CollisionAP.this.p1New, CollisionAP.this.p2New, 320);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(CollisionAP.this.text15, 50, 40);
            g.drawString(CollisionAP.this.text16, 50, 295);
            String unit = "m kg/s";
            this.write(g, CollisionAP.this.text19, p, unit, 200, 130, 0);
            this.write(g, CollisionAP.this.text19, p, unit, 200, 385, 0);
            g.setColor(CollisionAP.this.color1);
            this.write(g, CollisionAP.this.text06, CollisionAP.this.p1Old, unit, 50, 105, -1);
            this.write(g, CollisionAP.this.text06, CollisionAP.this.p1New, unit, 50, 360, -1);
            g.setColor(CollisionAP.this.color2);
            this.write(g, CollisionAP.this.text07, CollisionAP.this.p2Old, unit, 350, 105, 1);
            this.write(g, CollisionAP.this.text07, CollisionAP.this.p2New, unit, 350, 360, 1);
        }

        void diagram(Graphics2D g, int y, double part1, double part2) {
            int length = 300;
            int height = 30;
            int x = 50;
            CanvasAP.rectangle(g, x, y, part1 * (double)length, height, CollisionAP.this.color1, true);
            double w2 = part2 * (double)length;
            CanvasAP.rectangle(g, (double)(x + length) - w2, y, w2, height, CollisionAP.this.color2, true);
            CanvasAP.rectangle(g, x, y, length, height, CollisionAP.this.BLACK, false);
        }

        void energy(Graphics2D g) {
            double eOld = CollisionAP.this.e1Old + CollisionAP.this.e2Old;
            this.diagram(g, 60, CollisionAP.this.e1Old / eOld, CollisionAP.this.e2Old / eOld);
            this.diagram(g, 310, CollisionAP.this.e1New / eOld, CollisionAP.this.e2New / eOld);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(CollisionAP.this.BLACK);
            g.drawString(CollisionAP.this.text17, 50, 50);
            g.drawString(CollisionAP.this.text18, 50, 300);
            g.setColor(CollisionAP.this.color1);
            this.write(g, CollisionAP.this.text06, CollisionAP.this.e1Old, CollisionAP.this.joule, 50, 105, -1);
            this.write(g, CollisionAP.this.text06, CollisionAP.this.e1New, CollisionAP.this.joule, 50, 355, -1);
            g.setColor(CollisionAP.this.color2);
            this.write(g, CollisionAP.this.text07, CollisionAP.this.e2Old, CollisionAP.this.joule, 350, 105, 1);
            this.write(g, CollisionAP.this.text07, CollisionAP.this.e2New, CollisionAP.this.joule, 350, 355, 1);
            g.setColor(CollisionAP.this.BLACK);
            this.write(g, CollisionAP.this.text20, eOld, CollisionAP.this.joule, 200, 130, 0);
            this.write(g, CollisionAP.this.text20, CollisionAP.this.e1New + CollisionAP.this.e2New, CollisionAP.this.joule, 200, 380, 0);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            g.setClip(1, 1, 398, 438);
            CanvasAP.rectangle(g2, 0.0, 215.0, 400.0, 10.0, CollisionAP.this.BLACK, true);
            CollisionAP.this.calculateX();
            this.wagon(g2, CollisionAP.this.color1, CollisionAP.this.positions[0], CollisionAP.this.height1);
            this.wagon(g2, CollisionAP.this.color2, CollisionAP.this.positions[1], CollisionAP.this.height2);
            if (CollisionAP.this.elastic) {
                double xL = CollisionAP.this.positions[0] + 0.05;
                if (CollisionAP.this.t < CollisionAP.this.tBeg || CollisionAP.this.t > CollisionAP.this.tEnd) {
                    this.spring(g2, xL, xL + 0.05);
                } else {
                    this.spring(g2, xL, CollisionAP.this.positions[1] - 0.05);
                }
            } else {
                double dt = CollisionAP.this.tEnd - CollisionAP.this.tBeg;
                boolean condition = CollisionAP.this.t < CollisionAP.this.tBeg || CollisionAP.this.t > CollisionAP.this.tEnd - 0.2 * dt;
                double alpha = condition ? 0.0 : (CollisionAP.this.t - CollisionAP.this.tBeg) * 0.25 / dt;
                this.kupplung(g2, CollisionAP.this.positions[0], CollisionAP.this.positions[1], alpha);
            }
            double xS = (CollisionAP.this.m1 * CollisionAP.this.positions[0] + CollisionAP.this.m2 * CollisionAP.this.positions[1]) / (CollisionAP.this.m1 + CollisionAP.this.m2);
            xS *= 400.0;
            if (CollisionAP.this.t > 0.0) {
                CanvasAP.circle(g2, xS, 220.0, 2.0, CollisionAP.this.bgCanvas);
            }
            if (CollisionAP.this.rbV.isSelected()) {
                this.velocity(g2);
            } else if (CollisionAP.this.rbP.isSelected()) {
                this.momentum(g2);
            } else if (CollisionAP.this.rbE.isSelected()) {
                this.energy(g2);
            }
        }
    }
}

